package com.kyfexuwu.server_guis;

import com.kyfexuwu.server_guis.consumers.ClickConsumer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGUIs implements DedicatedServerModInitializer {
	public static final Logger LOGGER = LoggerFactory.getLogger("Server GUIs");

	@Override
	public void onInitializeServer() {
		//if(FoxEntity.class.getSimpleName().equals("FoxEntity")) Testing.test();
		LOGGER.info("Server GUIs loaded!");
	}

	public static ClickConsumer<?> nothingClick(){ return (_1, _2, _3, _4, _5, _6)->{}; }
	private static final ClickConsumer<?> nothingClickInst = nothingClick();
	public static final InvGUIItem IMMOVABLE = new InvGUIItem() {
		private static final class_1799 item = class_1802.field_8157.method_7854().method_7977(class_2561.method_30163("§f"));

		@Override
		public class_1799 getItem(class_3222 player, InvGUI<?> gui, Object argument) { return item; }
		@Override
		public ClickConsumer<?> onClick() { return nothingClickInst; }
	};
	public static final InvGUIItem EMPTY = new InvGUIItem() {
		@Override
		public class_1799 getItem(class_3222 player, InvGUI<?> gui, Object argument) {
			return class_1799.field_8037;
		}

		@Override
		public ClickConsumer<?> onClick() { return nothingClickInst; }
	};
	public enum ScreenType{
		GENERIC_9X1(class_3917.field_18664,9),
		GENERIC_9X2(class_3917.field_18665,18),
		GENERIC_9X3(class_3917.field_17326,27),
		GENERIC_9X4(class_3917.field_18666,36),
		GENERIC_9X5(class_3917.field_18667,45),
		GENERIC_9X6(class_3917.field_17327,54),
		GENERIC_3X3(class_3917.field_17328,9),
		ANVIL(class_3917.field_17329,3),
		BEACON(class_3917.field_17330,1, 3),
		BLAST_FURNACE(class_3917.field_17331,3, 4),
		BREWING_STAND(class_3917.field_17332,5, 2),
		CARTOGRAPHY_TABLE(class_3917.field_17343, 3),
		CRAFTING(class_3917.field_17333, 10),
		ENCHANTMENT(class_3917.field_17334, 2, 10),
		FURNACE(class_3917.field_17335,3, 4),
		GRINDSTONE(class_3917.field_17336,3),
		HOPPER(class_3917.field_17337,5),
		LECTERN(class_3917.field_17338, 1, 1), //for books
		LEGACY_SMITHING(class_3917.field_22484, 3),
		LOOM(class_3917.field_17339, 4, 1),//make sure banner slot is banner, and dye slot is dye
		MERCHANT(class_3917.field_17340, 3),
		//FUTURE_SMITHING
		SMOKER(class_3917.field_17342,3, 4),
		STONECUTTER(class_3917.field_17625, 2, 1);

		//book (edit?)
		//command block
		//creative inventory
		//sign edit
		//horse
		//inventory?
		//jigsaw
		//structure block

		public final class_3917<?> type;
		public final int slotCount;
		public final int propCount;
		ScreenType(class_3917<?> type, int slotCount){
			this(type, slotCount, 0);
		}
		ScreenType(class_3917<?> type, int slotCount, int propCount){
			this.type=type;
			this.slotCount=slotCount;
			this.propCount=propCount;
		}
	}

	public static class_1799 getPlayerHead(int i1, int i2, int i3, int i4, String textureString){
		var val = new class_2487();
		val.method_10582("Value", textureString);
		var textures = new class_2499();
		textures.method_10531(0, val);
		var props = new class_2487();
		props.method_10566("textures", textures);

		var nbt = new class_2487();
		nbt.method_10566("Id",new class_2495(new int[]{i1, i2, i3, i4}));
		nbt.method_10566("Properties",props);

		var finalCompound = new class_2487();
		finalCompound.method_10566("SkullOwner",nbt);

		var head = new class_1799(class_2246.field_10432);
		head.method_7980(finalCompound);
		return head;
	}
	public static class_1799 getPlayerHead(String username){
		var finalCompound = new class_2487();
		finalCompound.method_10566("SkullOwner", class_2519.method_23256(username));

		var head = new class_1799(class_2246.field_10432);
		head.method_7980(finalCompound);
		return head;
	}
}
