/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.server_guis;

import com.kyfexuwu.server_guis.InvGUIItem;
import com.kyfexuwu.server_guis.ServerGUIs;
import com.kyfexuwu.server_guis.ServerGuiHandler;
import com.kyfexuwu.server_guis.consumers.AnvilTypeConsumer;
import com.kyfexuwu.server_guis.consumers.BeaconInteractionConsumer;
import com.kyfexuwu.server_guis.consumers.CloseConsumer;
import com.kyfexuwu.server_guis.consumers.PropertyUpdateConsumer;
import com.kyfexuwu.server_guis.consumers.ShiftClickConsumer;
import com.kyfexuwu.server_guis.consumers.SlotUpdateConsumer;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3919;

public class InvGUI<T> {
    private ServerGuiHandler handler;
    public final ServerGUIs.ScreenType type;
    public final class_2561 title;
    public final InvGUIItem[] items;
    public final class_3913 propertyDelegate;
    private CloseConsumer<T> onClose;
    private ShiftClickConsumer<T> onShiftClick;
    private SlotUpdateConsumer<T> onSlotUpdate;
    private PropertyUpdateConsumer<T> onPropertyUpdate;
    private AnvilTypeConsumer<T> onAnvilType;
    private BeaconInteractionConsumer<T> onBeaconChange;
    private String anvilText = "";

    public ServerGuiHandler getHandler() {
        return this.handler;
    }

    public void onClose() {
        this.onClose.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument));
    }

    public class_1799 onShiftClick(int slotNum) {
        return this.onShiftClick.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument), slotNum);
    }

    public void onSlotUpdate(int slotNum, class_1799 stack) {
        this.onSlotUpdate.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument), slotNum, stack);
    }

    public void onPropertyUpdate(int property, int value) {
        this.onPropertyUpdate.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument), property, value);
    }

    public void onAnvilType(String newText) {
        this.anvilText = newText;
        this.onAnvilType.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument), newText);
    }

    public void onBeaconChange(Optional<class_1291> effect1, Optional<class_1291> effect2) {
        this.onBeaconChange.consume(this.getHandler().player, this, ServerGuiHandler.appeaseCompiler(this.getHandler().argument), effect1, effect2);
    }

    public InvGUI(ServerGUIs.ScreenType type, class_2561 title, InvGUIItem[] items) {
        this.type = type;
        this.title = title;
        this.items = items;
        this.propertyDelegate = new class_3919(type.propCount);
    }

    public void open(class_3222 player, final T argument) {
        final InvGUI thisObj = this;
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return thisObj.title;
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                thisObj.handler = new ServerGuiHandler(syncId, playerInventory, thisObj.type, thisObj, argument);
                thisObj.handler.method_7596(new class_1712(){

                    public void method_7635(class_1703 handler, int slotNum, class_1799 stack) {
                        thisObj.onSlotUpdate(slotNum, stack);
                    }

                    public void method_7633(class_1703 handler, int property, int value) {
                        thisObj.onPropertyUpdate(property, value);
                    }
                });
                return thisObj.handler;
            }
        });
    }

    public String getAnvilText() {
        return this.anvilText;
    }

    public static class Template<T> {
        public final ServerGUIs.ScreenType type;
        public final class_2561 title;
        public final InvGUIItem[] items;
        private Builder<T> builder = (player, template, arg) -> new InvGUI(template.type, template.title, template.items);
        private CloseConsumer<T> onCloseConsumer = (player, thisInv, argument) -> {};
        private ShiftClickConsumer<T> onShiftClickConsumer = (player, thisInv, argument, slotNum) -> class_1799.field_8037;
        private SlotUpdateConsumer<T> onSlotUpdateConsumer = (player, thisInv, argument, slotNum, stack) -> {};
        private PropertyUpdateConsumer<T> onPropertyUpdateConsumer = (player, thisInv, argument, property, value) -> {};
        private AnvilTypeConsumer<T> onAnvilTypeConsumer = (player, thisInv, argument, newText) -> {};
        private BeaconInteractionConsumer<T> onBeaconChangeConsumer = (player, thisInv, argument, effect1, effect2) -> {};

        public Template(ServerGUIs.ScreenType type, class_2561 title, InvGUIItem[] items) {
            this.type = type;
            this.title = title;
            this.items = items;
        }

        public Template<T> toBuild(Builder<T> builder) {
            this.builder = builder;
            return this;
        }

        public Template<T> onClose(CloseConsumer<T> onClose) {
            this.onCloseConsumer = onClose;
            return this;
        }

        public Template<T> onShiftClick(ShiftClickConsumer<T> onShiftClick) {
            this.onShiftClickConsumer = onShiftClick;
            return this;
        }

        public Template<T> onSlotUpdate(SlotUpdateConsumer<T> onSlotUpdate) {
            this.onSlotUpdateConsumer = onSlotUpdate;
            return this;
        }

        public Template<T> onPropertyUpdate(PropertyUpdateConsumer<T> onPropertyUpdate) {
            this.onPropertyUpdateConsumer = onPropertyUpdate;
            return this;
        }

        public Template<T> onAnvilType(AnvilTypeConsumer<T> onAnvilType) {
            this.onAnvilTypeConsumer = onAnvilType;
            return this;
        }

        public Template<T> onBeaconChange(BeaconInteractionConsumer<T> onBeaconChange) {
            this.onBeaconChangeConsumer = onBeaconChange;
            return this;
        }

        public InvGUI<T> build(class_3222 player, T arg) {
            InvGUI<T> toReturn = this.builder.build(player, this, arg);
            toReturn.onClose = this.onCloseConsumer;
            toReturn.onShiftClick = this.onShiftClickConsumer;
            toReturn.onSlotUpdate = this.onSlotUpdateConsumer;
            toReturn.onPropertyUpdate = this.onPropertyUpdateConsumer;
            toReturn.onAnvilType = this.onAnvilTypeConsumer;
            toReturn.onBeaconChange = this.onBeaconChangeConsumer;
            return toReturn;
        }

        public void buildAndOpen(class_3222 player, T arg) {
            this.build(player, arg).open(player, arg);
        }
    }

    @FunctionalInterface
    public static interface Builder<T> {
        public InvGUI<T> build(class_3222 var1, Template<T> var2, T var3);
    }
}

